
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1130.C - Message 1130 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1130 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1130.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:52   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:41:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:24   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 10:04:58   COLEJ
//   Repositioned sequence number up one.
//   
//      Rev 1.0   13 May 1996 14:52:54   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1130 message from the ZMsgBuf.
//
void Dec1130(tMSGBUF *ZMsgBuf, tMSG1130 *Msg)
{
   GetShort  (&Msg->SequenceNumber          , ZMsgBuf, 8);     // ND
   GetUShort (&Msg->Port1.DataBits          , ZMsgBuf, 9);     // 0=7 bits 
   GetUShort (&Msg->Port1.StopBits          , ZMsgBuf,10);     // 0=1 bit 
   GetUShort (&Msg->Port1.Parity            , ZMsgBuf,11);     // 0=none 
   GetUShort (&Msg->Port1.BitRate           , ZMsgBuf,12);     // 0=custom 
   GetUShort (&Msg->Port1.Prescale          , ZMsgBuf,13);     // ND 
   GetUShort (&Msg->Port1.Postscale         , ZMsgBuf,14);     // ND     
   GetUShort (&Msg->Port2.DataBits          , ZMsgBuf,15);     // 0=7 bits    
   GetUShort (&Msg->Port2.StopBits          , ZMsgBuf,16);     // 0=1 bit 
   GetUShort (&Msg->Port2.Parity            , ZMsgBuf,17);     // 0=none 
   GetUShort (&Msg->Port2.BitRate           , ZMsgBuf,18);     // 0=custom 
   GetUShort (&Msg->Port2.Prescale          , ZMsgBuf,19);     // ND 
   GetUShort (&Msg->Port2.Postscale         , ZMsgBuf,20);     // ND 
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1130 message in the ZMsgBuf. 
//
void Bld1130(tMSGBUF *ZMsgBuf, tMSG1130 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1130                          , ZMsgBuf, 2);     // message number
   PutShort  (15                            , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request
 //PutShort  (CheckSum(ZMsgBuf[0], 4)       , ZMsgBuf, 5);     // header check sum
                                                  
   PutShort  (Msg->SequenceNumber           , ZMsgBuf, 8);     // ND
   PutUShort (Msg->Port1.DataBits           , ZMsgBuf, 9);     // 0=7 bits 
   PutUShort (Msg->Port1.StopBits           , ZMsgBuf,10);     // 0=1 bit 
   PutUShort (Msg->Port1.Parity             , ZMsgBuf,11);     // 0=none 
   PutUShort (Msg->Port1.BitRate            , ZMsgBuf,12);     // 0=custom 
   PutUShort (Msg->Port1.Prescale           , ZMsgBuf,13);     // ND 
   PutUShort (Msg->Port1.Postscale          , ZMsgBuf,14);     // ND     
   PutUShort (Msg->Port2.DataBits           , ZMsgBuf,15);     // 0=7 bits    
   PutUShort (Msg->Port2.StopBits           , ZMsgBuf,16);     // 0=1 bit 
   PutUShort (Msg->Port2.Parity             , ZMsgBuf,17);     // 0=none 
   PutUShort (Msg->Port2.BitRate            , ZMsgBuf,18);     // 0=custom 
   PutUShort (Msg->Port2.Prescale           , ZMsgBuf,19);     // ND 
   PutUShort (Msg->Port2.Postscale          , ZMsgBuf,20);     // ND 

 //PutShort  (CheckSum(ZMsgBuf, 6, 9)       , ZMsgBuf, 13);    // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1130 message from the ZMsgBuf.
//
void Show1130(tMSG1130 *Msg)
{
   char    Buf[80] = "";
   char    *Parity[3] = {"N", " O", "E"};      
   char    *BitRate[12] = 
                 {"     0", "   300", "   600", "  1200", "  2400", "  4800",
                  "  9600", " 19200", " 38400", " 57600", " 76800", "115200" };      

   char   HostPortParams[9] = "", AuxPortParams[9] = ""; 
 
   // perform special processing for output
   if(Msg->Port1.BitRate){ 
      sprintf(HostPortParams,"%6s%1s%1d%1d", 
              BitRate[Msg->Port1.BitRate],
              Parity[Msg->Port1.Parity],
              Msg->Port1.DataBits+7, Msg->Port1.StopBits+1);   
   }
   else{
      sprintf(HostPortParams,"C%3d:%1d%1s%1d%1d", 
              Msg->Port1.Prescale, Msg->Port1.Postscale,
              Parity[Msg->Port1.Parity], 
              Msg->Port1.DataBits+7, Msg->Port1.StopBits+1);  
   }
   
   if(Msg->Port2.BitRate){ 
      sprintf(AuxPortParams,"%6s%1s%1d%1d", 
              BitRate[Msg->Port2.BitRate],
              Parity[Msg->Port2.Parity],
              Msg->Port2.DataBits+7, Msg->Port2.StopBits+1);   
   }
   else{
      sprintf(AuxPortParams,"C%3d:%1d%1s%1d%1d", 
              Msg->Port2.Prescale, Msg->Port2.Postscale,
              Parity[Msg->Port2.Parity], 
              Msg->Port2.DataBits+7, Msg->Port2.StopBits+1);  
   }

   // output the data items   
   sprintf(Buf,"%05d"  ,Msg->SequenceNumber       );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%09s"  ,HostPortParams            );ShowText(Buf,PRTR   ,PRTC+ 8);
   sprintf(Buf,"%09s"  ,AuxPortParams             );ShowText(Buf,PRTR+ 1,PRTC+ 8);
}                                                 
                                      
                                           
